/***************************************************************************
                          LOW_exception.cpp  -  description
                             -------------------
    begin                : Sat Jul 6 2002
    copyright            : (C) 2002 by Harald Roelle, Helmut Reiser
    email                : roelle@informatik.uni-muenchen.de, reiser@informatik.uni-muenchen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "LOW_exception.h"
#include "LOW_helper_msglog.h"


//=====================================================================================
//
// static attributes
//

bool LOW_exception::logOnCreation = false;


//=====================================================================================
//
// constructors
//

LOW_exception::LOW_exception() :
  errNum( 0),
  message( "")
{
}

LOW_exception::LOW_exception( const std::string inMsg, const std::string inFile, const int inLine) : 
  errNum( 0),
  message( inMsg),
  file( inFile),
  line( inLine)
{
  if ( logOnCreation )
    logException( "[auto-logged on creation] ");
}

LOW_exception::LOW_exception( const int inErrNum, const std::string inMsg, const std::string inFile, const int inLine) : 
  errNum( inErrNum),
  message( inMsg),
  file( inFile),
  line( inLine)
{
  if ( logOnCreation )
    logException( "[auto-logged on creation] ");
}

LOW_exception::~LOW_exception()
{
}
  
  
//=====================================================================================
//
// static methods
//

void LOW_exception::setLogOnCreation( const bool inLogOnCreation)
{
  logOnCreation = inLogOnCreation;
}


bool LOW_exception::getLogOnCreation()
{
  return logOnCreation;
}
    

//=====================================================================================
//
// static methods
//

void LOW_exception::logException( const std::string inPrefix)
{
  if ( errNum == 0 )
    LOW_helper_msglog::printError( "%s%s {file: %s, line: %d}", inPrefix.c_str(), message.c_str(), file.c_str(), line);
  else
    LOW_helper_msglog::printPerror( errNum, "%s%s {file: %s, line: %d}", inPrefix.c_str(), message.c_str(), file.c_str(), line);
}
