/***************************************************************************
                          LOW_semaphoreSetFactory.cpp  -  description
                             -------------------
    begin                : Tue Jul 30 2002
    copyright            : (C) 2002 by Harald Roelle, Helmut Reiser
    email                : roelle@informatik.uni-muenchen.de, reiser@informatik.uni-muenchen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "LOW_semaphoreSetFactory.h"
#include "LOW_semaphoreSet_SysV.h"


//=====================================================================================
//
// static factory
//

int LOW_semaphoreSetFactory::getMaxSemaphoresPerSet()
{
#ifdef __linux__
  // for now it has to be hardcoded, because a
  // #include <linux/sem.h>, where SEMMSL is defined,
  // interferes with other definitions
  return 250;
#endif
}


LOW_semaphoreSet* LOW_semaphoreSetFactory::new_semaphoreSet( const semSetIPCKey_t inSemSetIPCKey, unsigned int inCount, unsigned int inInit)
{
#ifdef __linux__
  return new LOW_semaphoreSet_SysV( inSemSetIPCKey, inCount, inInit);
#endif
}
